# PayHive Payments WordPress Plugin

A WordPress plugin that integrates with PayHive API to accept mobile money payments (MTN, Airtel) for Uganda with support for both sandbox and live modes.

## Features

- **Admin Settings Page**: Configure API credentials, toggle between sandbox/live mode, set default fees
- **Payment Shortcode**: Easy-to-use shortcode for embedding payment forms in posts and pages
- **API Integration**: Full integration with PayHive Laravel API
- **Mobile Money Support**: MTN and Airtel mobile money support for Uganda
- **Debug Logging**: All API requests and responses logged to WordPress debug log
- **Security**: API secrets never exposed to front-end, proper nonce verification
- **WordPress Standards**: Follows WordPress coding standards and best practices

## Installation

1. Upload the `payhive-payments` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to Settings → PayHive Payments to configure your API credentials

## Configuration

### Admin Settings

Go to **Settings → PayHive Payments** in your WordPress admin panel:

1. **API Key**: Enter your PayHive API key
2. **Secret Key**: Enter your PayHive secret key (stored securely)
3. **Mode**: Choose between Sandbox (test) or Live (production) mode
4. **Default Fee**: Set the default fee percentage (can be overridden per payment)

## Usage

### Basic Shortcode

Insert the following shortcode in any post or page:

```
[payhive_payment amount="10000" description="Product Purchase"]
```

### Shortcode Parameters

- `amount` (required): Payment amount in UGX
- `description` (required): Payment description
- `button_text` (optional): Custom button text (default: "Pay Now")
- `currency` (optional): Currency code (default: "UGX")

### Examples

**Simple payment form:**
```
[payhive_payment amount="50000" description="Monthly Subscription"]
```

**Custom button text:**
```
[payhive_payment amount="25000" description="Premium Package" button_text="Subscribe Now"]
```

## API Endpoints

The plugin communicates with the following PayHive API endpoints:

- `POST /api/v1/payment-links` - Create payment link
- `POST /api/v1/payments/process` - Process mobile money payment
- `GET /api/v1/payments/{id}` - Get payment status
- `GET /api/v1/health` - Test API connection

## Debug Logging

To enable debug logging, add the following to your `wp-config.php`:

```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

All API requests and responses will be logged to `/wp-content/debug.log`.

## Security Features

- API credentials stored in WordPress options (database)
- Secret key never exposed in HTML or JavaScript
- All API calls made server-side only
- WordPress nonce verification for all forms
- Input sanitization and validation
- Output escaping

## File Structure

```
payhive-payments/
├── payhive-payments.php          # Main plugin file
├── includes/
│   ├── class-payhive-admin.php   # Admin settings page
│   ├── class-payhive-api.php     # API handler
│   └── class-payhive-shortcode.php # Shortcode handler
├── assets/
│   ├── css/
│   │   ├── admin-style.css       # Admin styles
│   │   └── frontend-style.css    # Frontend styles
│   └── js/
│       ├── admin-script.js       # Admin scripts
│       └── frontend-script.js    # Frontend scripts
└── README.md                      # This file
```

## Requirements

- WordPress 5.0 or higher
- PHP 7.2 or higher
- Valid PayHive API credentials

## Support

For support, please contact PayHive support or visit https://payhive.com

## License

GPL v2 or later

## Changelog

### Version 1.0.0
- Initial release
- Admin settings page
- Payment shortcode
- API integration
- Mobile money support (MTN, Airtel)
- Debug logging
